class Heap {
    private int[] Field;
    private boolean Sorted = false;

    public Heap(int[] AField) {
        Field = new int[AField.length + 1];
        for (int i = 0; i < AField.length; i++)
            Field[i + 1] = AField[i];
    }

    public Heap(int FieldSize) {
        Field = new int[FieldSize + 1];
    }

    public int getField(int Index) {
        return Field[Index];
    }

    public void setField(int Index, int Value) {
        Field[Index] = Value;
    }

    private void Swap(int a, int b) {
        int Tmp = Field[a];

        Field[a] = Field[b];
        Field[b] = Tmp;
    }

    private void Heapify(int Current, int fldSize) {
        int Left =  Current * 2,
            Right = Left + 1,
            Child;

        if (Left <= fldSize && Right > fldSize)
            Swap(Left, Current); else
        if (Right <= fldSize) {
            Child = (Field[Left] < Field[Right]) ? Left : Right;
            if (Field[Child] < Field[Current]) {
                Swap(Child, Current);
                Heapify(Child, fldSize);
            }
        }
    }

    private void Build() {
        for (int i = Field.length / 2; i > 0; i--)
            Heapify(i, Field.length - 1);
    }

    public void Sort() {
        Build();
        for (int i = Field.length - 1; i > 1; i--) {
            Swap(1, i);
            Heapify(1, i - 1);
        }
        Sorted = true;
    }

    public void randomFill() {
        for (int i = 1; i < Field.length; i++)
            Field[i] = (int)(java.lang.Math.random() * 1000);
        Sorted = false;
    }

    public String toString() {
        String s = "Heap = (";

        if (!Sorted)
            for (int i = 1; i < Field.length; i++)
                s += Field[i] + (i != Field.length - 1 ? " | " : ")"); else
            for (int i = Field.length - 1; i > 0; i--)
                s += Field[i] + (i != 1 ? " | " : ")");

        return s;
    }
}

public class HeapSort {
    public static void main(String[] args) {
        Heap myHeap = new Heap(20);

        myHeap.randomFill();
        System.out.println(myHeap + "\n");

        myHeap.Sort();
        System.out.println(myHeap + "\n");
    }
}
